'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    'MwSt-Splitting-Tabelle ein-/ausschalten
    If Me.Kasten_MwSt_Splitting.Value = False Then
        Me.ReTestlauf_MwSt_Splitting.Visible = False                    'Splitting-Tabelle
        Me.Ueber_MwSt_Kz.Visible = False                                'Kz-berschrift hier
       Me.Ueber_MwSt_Kz_Kopf.Visible = False                            'Kz-berschrift im bergeord. Formular
    Else
        Me.ReTestlauf_MwSt_Splitting.Visible = True                     'Splitting-Tabelle
        Me.Ueber_MwSt_Kz.Visible = True                                 'Kz-berschrift hier
        Me.Ueber_MwSt_Kz_Kopf.Visible = True                            'Kz-berschrift im bergeord. Formular
    End If
    
    If Me.Kasten_MwSt_Splitting.Value = True Then
        Me.Bez_Steuer.Caption = Trim(ReMwStKuerzel) & ":"
    Else
        Me.Bez_Steuer.Caption = Format(Me.MwSt_Satz.Value, "#,##0.00") & " % " & Trim(ReMwStKuerzel)
    End If
    
End Sub

Private Sub Report_Activate()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Report_Close()
    TestlaufAnsichtGeschlossen = True
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    Me.ImpFusszeile.Caption = ImpressumBerichtsfuss
    
    'berschrift fr Dauer einstellen
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten/berechnet"
            Me.Dauer_Bezeichnungsfeld_Kopf.Caption = "Minuten/berechnet"
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std / berechnet"
            Me.Dauer_Bezeichnungsfeld_Kopf.Caption = "Std / berechnet"
        Case 8      'Std:Min  (01:45)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std:Min/berechnet"
            Me.Dauer_Bezeichnungsfeld_Kopf.Caption = "Std:Min/berechnet"
        Case Else
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten/berechnet"
            Me.Dauer_Bezeichnungsfeld_Kopf.Caption = "Minuten/berechnet"
    End Select

    'aktuelles Whrungsformat des Systems einstellen
    Me.Re_Netto.Format = "Currency"
    Me.Re_MwSt.Format = "Currency"
    Me.Re_Brutto.Format = "Currency"
    Me.Re_Netto_Gesamtsumme.Format = "Currency"
    Me.Re_MwSt_Gesamtsumme.Format = "Currency"
    Me.Re_Brutto_Gesamtsumme.Format = "Currency"
End Sub
